/* "GTTY" Glass TTY + Load paper tape software into a PDP-8,

    Lyle Bickley, Bickley Consulting West Inc.
    Version 0.96a
	- added check for BELL and visual printout; Jack Rubin 9/6/14

    Copyright 2006 Lyle Bickley

    No warranties expressed or implied.
    Free license for non-commercial use. Please contact
    Bickley Consulting West Inc. for commercial use:
    http://bickleywest.com
*/

#include stdio.h
#include comm.h
#include file.h
#include video.h

static unsigned baudrate[]={_110, _300, _600, _1200, _2400, _4800, _9600, _19200, _38400};
static char *baudtext[]={"110", "300", "600", "1200", "2400", "4800", "9600", "19200", "38400"};

main(int argc, char *argv[])

{
    FILE *fhr, *fhc;

    unsigned char *p, *ptxt;
    unsigned baud;
    int c, d, build, found, i, j, port, skip, sbits, tcr, tspace;
    int com, kbd, savpos, tabpos, tabsiz, crflag, cflag, ctsflag, morech;
    char fname[40], lname[40], yn[1];

    c=cflag=crflag=0; /* Init flags to default */
    d=42;          /* "*" */
    tspace=32;     /* space */
    tcr=141;       /* TTY CR */
    tabsiz=8;      /* default tab size */

    /* Communication Defaults */
    ctsflag=1; port=1; baud=_9600; sbits=STOP_1;

    for (i=1; i<argc; ++i) {
        p=argv[i];
        switch((toupper(*p++)<<8)|toupper(*p++)) {

            case '-B':
                ptxt=argv[++i];
                found=0;
                for (j=0; j<9; ++j) {
                    if(!strcmp(ptxt, baudtext[j])) {
                        baud=baudrate[j];
                        found=1;
                    }
                }
                if(!found) {
                    fprintf(stderr,"Invalid baud rate specified\n");
                    exit(1);
                }
            /*  printf("debug baud=%d\n",baud); */
                break;

            case '-C':
                crflag=1;
                break;

            case '-N':
                ctsflag=0;
                break;

            case '-P':
                port=atoi(argv[++i]);
                break;

            case '-S':
                switch (atoi(argv[++i])) {
                    case 1:
                        sbits=STOP_1;
                        break;
                    case 2:
                        sbits=STOP_2;
                        break;
                    default:
                    fprintf(stderr,"Number of stop bits must be 1 or 2\n");
                    exit(1);
                }
                break;

            case '-T':
                tabsiz=atoi(argv[++i]);
                if(!tabsiz) tabsiz=8;
                break;

            case '-H':
                fprintf(stderr, "Usage: %s [-b baud] [-c] [-h] [-n] [-p port] [-s bits] [-t tabsize]\n", argv[0]);
                exit(0);

            default  :
                fprintf(stderr,"Unknown parameter %s\n", argv[i]);
                fprintf(stderr, "Usage: %s [-b baud] [-c] [-h] [-n] [-p port] [-s bits] [-t tabsize]\n", argv[0]);
                exit(1);
        }
    }


    if (Copen(port, baud, PAR_NO|DATA_8|sbits, SET_RTS|SET_DTR|OUTPUT_2)) {
        fprintf(stderr,"Cannot open COM port %1d\n",port);
        exit(1);
    }

    disable();
    Cflags |= TRANSPARENT;
    enable();

    vopen();
    vcursor_line();
    vprintf("GTTY 0.96a, (c) Bickley Consulting West Inc. 2006\r\nPrint -BELL- symbol");
    vupdatexy();

    while (1) {

        /* F1 is Help */
        if((kbd=vtstc())==0xff8d) {
            vprintf("\nF1=Help, F2=Upload, F3=Escape PTR, F4=Capture, F5=End Capture,\n");
            vprintf("F6=Clear Screen, F8=Exit\n");
            vupdatexy();
            }

        /* F2 is Load paper tape file to PDP8 */
        if(kbd==0xff8e) {
            build=skip=0;
            morech=1;
            lname[0]=yn[0]=0;
            savpos=V_XY;
            vgets(5,5,"Name of PT file to upload: ",lname,40);
            vgets(5,5,"Skip to clean leader? [Y/N]: ",yn,1);
            if(toupper(yn[0])=='Y') skip=1;
            yn[0]=0;
            vgets(5,5,"Output CR before upload? [Y/N]: ",yn,1);
            if(toupper(yn[0])=='Y') build=1;
            vcursor_line();
            vgotoxy(savpos&0xff, savpos>>8);
            if (!(fhr=fopen(lname,"rb"))) {
                vprintf("\nCannot access file '%s'!\n",lname);
                vupdatexy();
                morech=0;
            }
            if (skip & morech) {
                vprintf("\nSkipping to clean leader...\n");
                vupdatexy();
                while (c!=0x80) {
                    if((c=fgetc(fhr)) == EOF) {
                        vprintf("\nNo clean (8 punch only) leader found!\n");
                        vupdatexy();
                        c=0x80;
                        morech=0;
                        fclose(fhr);
                    }
                }  
            }

            if(build) {
                Cputc(tcr); /* CR */
                c=Cgetc();  /* Wait for CR */
                c=Cgetc();  /* Wait for ^ */
                Cputc(tcr); /* Another CR */
            }

            while (morech) {
                if ((c=fgetc(fhr)) != EOF) {
                    if(ctsflag) {
                        /* Spin waiting for RDR RUN to set */
                        while(Csignals() != CTS) {
                            /* test for F3 "escape" key */
                            if(vtstc() == 0xff8f) {
                                vprintf("\nEscaped from 'PT reader' wait\n");
                                vupdatexy();
                                goto ptexit;
                            }
                        }      
                    }
                    Cputc(c);
                    /* Spin waiting for slow Rdr Run FF to say not set */
                    if (ctsflag) while(Csignals() == CTS) j=j+1;
                    vputc(d);
                    vupdatexy();
                }
                else {
                   vprintf("\nEnd of file...\n");
                   vupdatexy();
                   morech=0;
                   fclose(fhr);
                }
            }
        }
        ptexit:

        /* F4 is Open Capture File */
        if(kbd==0xff90) {
            fname[0]=0;
            savpos=V_XY;
            vgets(5,5,"Name of Capture file: ", fname, 40);
            vcursor_line();
            vgotoxy(savpos&0xff, savpos>>8);
            fhc=fopen(fname, "wb");
            cflag=1;
            if(!fhc) {
                vprintf("\nError opening capture file!\n");
                vupdatexy();
                cflag=0;
            }
        }

        /* F5 is Close Capture File */

        if(kbd==0xff91) {
            if(cflag) {
                fclose(fhc);
                cflag=0;
                vprintf("\nCapture file closed...\n");
                vupdatexy();
            }
        }

        /*F6 is Clear Screen */

        if(kbd==0xff92) vclscr();

        /* F8 is Exit */

        if(kbd==0xff94) {
            vclscr();
            Cclose();
            printf("\nEnd of GTTY session...\n");
            exit(0);
        }

        if(kbd>0) {
            if (kbd == 10) {
                if (crflag) Cputc(kbd | 0x80); /* LF for non-OS/8 use */
                kbd=13; /* CR for OS/8 */
            }
            Cputc(kbd | 0x80);
        }
        else if ((kbd == 0xff8b)|(kbd == 0xff8c))
                Cputc(0xff);               /* DEL or BS = RUBOUT */

        if((com=Ctestc()) != -1) {
            if(cflag)
                fputc(com, fhc);      /* COMx to capture file */
            else {
                if((com & 0x7f) == 9) {  /* Is "tab" character? */
                    tabpos=tabsiz - ((V_XY & 0xFF) % tabsiz);  /* Yes */
                    while (tabpos) {
                        vputc(tspace);
                        tabpos--;
					}
					vupdatexy();
				}
			}	
            if((com & 0x7f) == 7) { /* BELL character */
                   vprintf("-BELL-\n");
                   vupdatexy();
            }
  			else {
                    vputc(com & 0x7f); /* char to screen */
                    vupdatexy();
				}
            }
        }
    }
